import sqlalchemy as sa

from src.tables.metadata import metadata


change_record_table = sa.Table(
    'change_records',
    metadata,
    sa.Column('id', sa.Integer, primary_key=True),
    sa.Column('source_id', sa.Integer, unique=True),
    sa.Column('workflow_id', sa.String),
    sa.Column('proposal_id', sa.String),
    sa.Column('budget_position_id', sa.Integer),
    sa.Column('budget_position_code', sa.Integer),
    sa.Column('started_at', sa.DateTime),
    sa.Column('resolved_at', sa.DateTime),
    sa.Column('effective_date', sa.DateTime),
    sa.Column('login', sa.String),
    sa.Column('join_at', sa.DateTime),
    sa.Column('staff_id', sa.Integer),
    sa.Column('person_id', sa.Integer),
    sa.Column('ticket', sa.String),
    sa.Column('optional_ticket', sa.String),
    sa.Column('vacancy_id', sa.Integer),
    sa.Column('department_id', sa.Integer),
    sa.Column('hr_product_id', sa.Integer),
    sa.Column('headcount', sa.Integer),
)
