import sqlalchemy as sa

from src.enitites import SourceType
from src.tables.metadata import metadata


department_fact_table = sa.Table(
    'department_fact',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),

    sa.Column('entity_id', None, sa.ForeignKey('department_entity.id'), nullable=False),
    sa.Column('valid_from', sa.DateTime, nullable=False),
    sa.Column('is_deleted', sa.Boolean, nullable=False),
    sa.Column('source', sa.Enum(SourceType), nullable=False),
    sa.Column('source_proposal_id', sa.String, nullable=True),
    sa.Column('name_en', sa.String, nullable=False),
    sa.Column('name_ru', sa.String, nullable=False),
    sa.Column('parent_id', None, sa.ForeignKey('department_entity.id'), nullable=True),

    sa.Column('source_modification_id', sa.BigInteger, nullable=False),
    sa.Column('source_modification_date', sa.DateTime, nullable=False),
)
