import sqlalchemy as sa

from src.tables.metadata import metadata


department_role_entity_table = sa.Table(
    'department_role_entity',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
    sa.Column('role_type', sa.String, unique=True, index=True, nullable=False),

    sa.Column('created_at', sa.DateTime, nullable=False),
    sa.Column('modified_at', sa.DateTime, nullable=False),
    sa.Column('external_id', sa.BigInteger, nullable=False),
)
