import sqlalchemy as sa

from src.tables.metadata import metadata


staff_role_in_department_link_table = sa.Table(
    'staff_role_in_department_link',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),


    sa.Column('role_id', None, sa.ForeignKey('department_role_entity.id')),
    sa.Column('department_role_fact_id', None, sa.ForeignKey('department_role_fact.id')),
    sa.Column('staff_id', None, sa.ForeignKey('staff_entity.id')),

    sa.Column('created_at', sa.DateTime, nullable=False),
    sa.Column('modified_at', sa.DateTime, nullable=False),
    sa.Column('external_id', sa.BigInteger, nullable=False),
)
