import sqlalchemy as sa

from src.tables.metadata import metadata


vacancy_entity_table = sa.Table(
    'vacancy_entity',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
    sa.Column('source_id', sa.BigInteger),
    sa.Column('name', sa.String),

    sa.Column('created_at', sa.DateTime, nullable=False),
    sa.Column('modified_at', sa.DateTime, nullable=False),
    sa.Column('external_id', sa.BigInteger, nullable=False),
)
