# staff-reader
Microservice for staff request proxying and caching

## Архитектура
* nginx
  Обычный nginx, в котором настроен апстрим на localhost:8080 и включено кеширование контента ( `proxy_cache` )
* tornado web server
  Стандартный асинхронный веб-сервер на tornado. Висит на 8080 порту и предоставляет API

## API
### Получение параметров пользователя
* GET запрос `/suggestuser?login=<логин пользователя на стаффе>
* RESPONSE - отдаём немодифицированный json-ответ от staff-а - словарь всех параметров пользователя, о которых знает staff

### В каких группах состоит пользователь
* GET запрос `/usergroups?login=<логин пользователя на стаффе>
* RESPONSE - отдаём немодифицированный json-ответ от staff-а - список групп 

### Все сотрудники группы
* GET запрос `/groupusers?url=<url группы на стаффе>
* RESPONSE - отдаём немодифицированный json-ответ от staff-а - список всех пользователей группы

## Особенности
* Микросервис общается с сервисом staff от имени робота "Робот Вертер" ( robot-e7n-staff-read ). Для этих целей был получен токен, который хранится в секретнице. Доступ к токену в секретнице расшарен на группу корпоративного обучения.
* На данном этапе микросервис - это внутренняя история и в нем нет никакой аутентификации входящих запросов.

## HOWTO
### сборка docker image-а
 * собираем:
`docker build -f docker/staff_reader.Dockerfile -t e7n-staff-reader-microsvc .`

 * провеяем , что image появился
`docker images`

### запуск контейнера
* запускаем
`docker run -p 8090:80  --name microservice e7n-staff-reader-microsvc`

* проверяем, что контейнер запущен
`docker ps -a`
