#!/usr/bin/env python3
import os
import sys
import time

if __name__ == "__main__":
    # will control uwsgi through master fifo file, see uwsgi.ini
    with open('/tmp/uwsgimasterfifo', 'w') as f:
        f.write('q')  # q - control char for graceful shutdown

    while True:
        # pidfile to check uwsgi is alive, see uwsgi.ini
        with open('/tmp/uwsgipidfile', 'r') as f:
            pid = int(f.readline())
            try:
                os.kill(pid, 0)
            except OSError:  # os.kill will raise error if there is no such process
                sys.exit(0)

            time.sleep(0.2)  # sleep before next check
