from staff.achievery.domain import GivenAchievement
from staff.achievery.permissions import RoleRegistry


class AchievementsContext(object):
    def __init__(self, target_login, viewer):
        self.target_login = target_login
        self.viewer = viewer
        self.roles = RoleRegistry(self.viewer)
        self.givens = (
            GivenAchievement.objects(self.viewer, self.roles)
            .filter(person__login=target_login, slot=[i for i in range(1, 13)])
            .select_related('achievement')
            .order_by('slot')
            .distinct()
        )

    def __iter__(self):
        return iter(self.givens)

    def __len__(self):
        return len(self.givens)
