from .. import schema
from ..fields import (
    PlainField,
    MultilingualField,
    RelatedField,
    IconField,
    MultilingualWikiField,
)

from .base import (
    SavableDomainObject,
    CreatableDomainObjectList,
    TimeStamped,
    SoftDeleted,
)
from .registry import domain_objects, domain_object_lists


__all__ = (
    'Achievement', 'AchievementList',
)


@domain_objects.register
class Achievement(TimeStamped, SoftDeleted, SavableDomainObject):
    model_class = 'achievery.Achievement'

    __search_fields__ = (  # Model fields, not controller's
        'title',
        'title_en',
        'description',
        'description_en',
        'description_short',
        'description_short_en',
        'service_name',
        'service_name_en',
    )

    native_lang = PlainField(schema_type=schema.TYPE.STRING)
    category = PlainField(schema_type=schema.TYPE.ENUM)
    description = MultilingualWikiField('description_html')
    description_html = MultilingualField()
    description_short = MultilingualField()
    title = MultilingualField()
    owner_group = RelatedField(related_class='OwnerGroup', assignable=True)
    service = RelatedField(related_class='Service', pseudo=True)
    icon_big = IconField(is_big=True, null=True)
    icon_small = IconField(is_big=False, null=True)

    @property
    def is_counter(self):
        return self.model.icon_set.exclude(level=-1).exists()

    def delete(self):
        self.soft_delete()
        self.save()

    def restore(self):
        self.soft_restore()
        self.save()


@domain_object_lists.register
class AchievementList(CreatableDomainObjectList):
    domain_object_class = Achievement
