from .. import schema
from ..fields import PlainField, RelatedListField

from .base import DomainObject
from .person import Person
from .registry import domain_objects


__all__ = (
    'OwnerGroup',
)


@domain_objects.register
class OwnerGroup(DomainObject):
    model_class = 'django_intranet_stuff.Group'

    id = PlainField(schema_type=schema.TYPE.NUMBER)
    name = PlainField(schema_type=schema.TYPE.STRING)
    url = PlainField(schema_type=schema.TYPE.STRING)
    members = RelatedListField(related_class=Person, model_field='members')
