from django.conf import settings

from .. import schema
from ..fields import NameField, PlainField

from .base import DomainObject, DomainObjectList
from .registry import domain_objects, domain_object_lists


__all__ = (
    'Person',
)


@domain_objects.register
class Person(DomainObject):
    MAX_SLOTS = settings.ACHIEVERY_MAX_SLOTS

    model_class = 'django_intranet_stuff.Staff'

    id = PlainField(schema_type=schema.TYPE.NUMBER)
    login = PlainField(schema_type=schema.TYPE.STRING)
    uid = PlainField(schema_type=schema.TYPE.STRING)
    name = NameField(spec={'first': 'first_name', 'last': 'last_name'})
    is_dismissed = PlainField(schema_type=schema.TYPE.BOOLEAN)
    lang_ui = PlainField(schema_type=schema.TYPE.STRING)
    work_email = PlainField(schema_type=schema.TYPE.STRING)
    inflections = PlainField()

    @property
    def free_slots(self):
        return [
            slot
            for slot in range(1, self.MAX_SLOTS + 1)
            if slot not in self.model.givenachievement_set.exclude(slot=None).values_list('slot', flat=True)
        ]


@domain_object_lists.register
class PersonList(DomainObjectList):
    domain_object_class = Person
