from .combined import NameField
from .icon import IconField
from .level import LevelField
from .multilingual import MultilingualField
from .plain import PlainField
from .related import RelatedField, RelatedListField
from .slot import SlotField
from .wiki import WikiField


class MultilingualWikiField(MultilingualField, WikiField):
    def set(self, instance, value):
        super(MultilingualWikiField, self).set(instance, value)
        setattr(instance, self.html_name, {
            k: self.wiki_format(v)
            for k, v in value.items()
        })


__all__ = (
    'NameField',
    'IconField',
    'LevelField',
    'MultilingualField',
    'PlainField',
    'RelatedField',
    'RelatedListField',
    'SlotField',
    'WikiField',
    'MultilingualWikiField',
)
