from .. import exceptions

from .plain import PlainField


class LevelField(PlainField):
    def validate(self, value):
        super(LevelField, self).validate(value)

        if value == 0 or value < -1:
            raise exceptions.UnacceptableLevel(value, data=value)
