from .. import schema

from .plain import PlainField
from .utils import MultilingualAdapter


class MultilingualField(PlainField):
    DEFAULT_SCHEMA_TYPE = schema.TYPE.OBJECT

    def get(self, instance, owner):
        return MultilingualAdapter(instance.model, self.name)

    def set(self, instance, value):
        adapter = MultilingualAdapter(instance.model, self.name)
        for key, val in value.items():
            setattr(adapter, key, val)

    def translate_lookup(self, nested, value, source_field):
        return MultilingualAdapter.translate_lookup(
            nested, value, self.name, source_field)

    @property
    def schema(self):
        s = {
            'type': self.schema_type,
        }
        if self.schema_type == self.DEFAULT_SCHEMA_TYPE:
            s.update({
                'additionalProperties': False,
                'properties': MultilingualAdapter.fields,
            })
        return s
