from staff.django_intranet_notifications.utils.wiki import WikiFormatter

from .plain import PlainField


class WikiField(PlainField):
    def __init__(self, html_name, *args, **kwargs):
        super(WikiField, self).__init__(*args, **kwargs)
        self.wf = WikiFormatter()
        self.html_name = html_name

    def wiki_format(self, value):
        return self.wf.to_html(value)

    def set(self, instance, value):
        super(WikiField, self).set(instance, value)
        setattr(instance, self.html_name, self.wiki_format(value))
