# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
            options={
                'permissions': (('external_with_achievery_access', 'External with achievery access'),),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Achievement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(verbose_name='models.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='models.modified_at-label', auto_now=True)),
                ('is_active', models.BooleanField(verbose_name='models.is_active-label', default=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('category', models.CharField(max_length=16, choices=[('fun', 'achievery.achievement.category.fun'), ('work', 'achievery.achievement.category.work')])),
                ('description', models.TextField(blank=True)),
                ('description_html', models.TextField(blank=True)),
                ('description_en', models.TextField(blank=True)),
                ('description_html_en', models.TextField(blank=True)),
                ('description_short', models.CharField(max_length=255, blank=True)),
                ('description_short_en', models.CharField(max_length=255, blank=True)),
                ('service_name', models.CharField(max_length=255, blank=True)),
                ('service_name_en', models.CharField(max_length=255, blank=True)),
                ('title', models.CharField(max_length=255, unique=True)),
                ('title_en', models.CharField(max_length=255, unique=True)),
            ],
            options={
                'permissions': (('change_achievement_status', 'Can change "is_active" field'),),
            },
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(verbose_name='models.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='models.modified_at-label', auto_now=True)),
                ('comment', models.TextField()),
                ('is_active', models.BooleanField(default=False)),
                ('is_hidden', models.BooleanField(default=False)),
                ('level', models.IntegerField()),
                ('revision', models.IntegerField()),
                ('slot', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GivenAchievement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(verbose_name='models.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='models.modified_at-label', auto_now=True)),
                ('is_active', models.BooleanField(verbose_name='models.is_active-label', default=True)),
                ('comment', models.TextField(blank=True)),
                ('comment_html', models.TextField(blank=True)),
                ('is_hidden', models.BooleanField(default=False)),
                ('level', models.IntegerField()),
                ('revision', models.IntegerField(default=0)),
                ('slot', models.IntegerField(blank=True, null=True)),
                ('last_event_at', models.DateTimeField(null=True)),
                ('achievement', models.ForeignKey(to='achievery.Achievement')),
            ],
        ),
        migrations.CreateModel(
            name='Icon',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('big_data', models.TextField(default='')),
                ('small_data', models.TextField(default='')),
                ('mime_type', models.CharField(max_length=16, blank=True, default='image/png;base64', choices=[('image/png;base64', 'image/png;base64')])),
                ('level', models.IntegerField()),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('achievement', models.ForeignKey(to='achievery.Achievement')),
            ],
        ),
    ]
