import base64

from rest_framework import renderers


class PNGRenderer(renderers.BaseRenderer):
    media_type = 'image/*'
    format = 'png'
    charset = None
    render_style = 'binary'

    def render(self, data, media_type=None, renderer_context=None):
        return base64.b64decode(data['data']) if 'data' in data else data
