from .base import Condition, Role, ANONYMOUS


class Admin(Role):
    """Всемогущий Админ"""
    def is_applicable(self):
        if self.user is ANONYMOUS:
            return False
        return self.user.in_groups.filter(url='achieveryadmin').exists()

    def check(self, field, perm):
        return True

    @classmethod
    def get_query(cls, user, model_class):
        return Condition(all=True)

    @classmethod
    def manages(cls, model_class):
        return True

    @classmethod
    def check_object(cls, role_registry, obj):
        return True
