from staff.groups.models import Group

from staff.achievery import models

from .base import Condition, Role
from .registry import library


__all__ = (
    'Anybody',
)


@library.register
class Anybody(Role):
    """Потусторонний пользователь"""

    fields = {
        models.Achievement: {
            'id': 'r',
            'category': 'r',
            'description': 'r',
            'description_html': 'r',
            'description_en': 'r',
            'description_html_en': 'r',
            'description_short': 'r',
            'description_short_en': 'r',
            'title': 'r',
            'title_en': 'r',
            'owner_group': 'r',
            'service': 'r',
            'icons_big': 'r',
            'icons_small': 'r',
            'created_at': 'r',
            'modified_at': 'r',
            'is_active': 'r',
            'native_lang': 'r',
            'service_name': 'r',
            'service_name_en': 'r',
        },
        models.GivenAchievement: {
            'id': 'r',
            'comment': 'r',
            'comment_html': 'r',
            'is_hidden': 'r',
            'is_active': 'r',
            'level': 'r',
            'revision': 'r',
            'slot': 'r',
            'achievement': 'r',
            'person': 'r',
            'events': 'r',
            'created_at': 'r',
            'modified_at': 'r',
            'last_event_at': 'r',
        },
        models.Icon: {
            'big_data': 'r',
            'small_data': 'r',
            'mime_type': 'r',
            'level': 'r',
            'achievement': 'r',
            'id': 'r',
            'modified_at': 'r',
        },
        models.Event: {
            'comment': 'r',
            'comment_html': 'r',
            'given_achievement': 'r',
            'initiator': 'r',
            'is_active': 'r',
            'is_hidden': 'r',
            'level': 'r',
            'revision': 'r',
            'slot': 'r',
            'created_at': 'r',
            'modified_at': 'r',
            'id': 'r',
        },
        Group: {
            'id': 'r',
            'name': 'r',
            'url': 'r',
            'members': 'r',
        }
    }

    def is_applicable(self):
        if isinstance(self.model, models.Achievement):
            return self.model.is_active

        if isinstance(self.model, models.GivenAchievement):
            return self.model.is_active and not self.model.is_hidden

        return False

    @classmethod
    def get_query(cls, user, model_class):
        return {
            models.Achievement:
                Condition(models.Achievement.queries.active),

            models.GivenAchievement:
                Condition(models.GivenAchievement.queries.active),

            models.Icon: Condition(all=True),

            models.Event: Condition(all=True),

            Group: Condition(all=True),

        }.get(model_class, Condition(none=True))

    @classmethod
    def check_object(cls, role_registry, obj):
        return {
            models.Achievement: getattr(obj, 'is_active', False),
            models.GivenAchievement: getattr(obj, 'is_active', False),
            models.Icon: True,
            models.Event: True,
            Group: True,
        }.get(type(obj), False)
