from .base import Condition, Role


class Creation(Role):
    """Creation means that model is creating at the moment
    and thus does not have any other roles"""

    def is_applicable(self):
        return self.model.id is None

    def check(self, field, perm):
        return True

    @classmethod
    def get_query(cls, user, model_class):
        return Condition(none=True)

    @classmethod
    def manages(cls, model_class):
        return False

    @classmethod
    def check_object(cls, role_registry, obj):
        return False
