from .. import models

from .base import Condition, Role


class Unmanaged(Role):
    """Unmanaged means that model is not managed by Achievery ACL"""

    def is_applicable(self):
        return self.model.__class__ not in models.library

    def check(self, field, perm):
        return True

    @classmethod
    def get_query(cls, user, model_class):
        if model_class in models.library:
            return Condition(none=True)
        else:
            return Condition(all=True)

    @classmethod
    def manages(cls, model_class):
        return model_class not in models.library

    @classmethod
    def check_object(cls, role_registry, obj):
        return not isinstance(obj, tuple(models.library))
