from functools import wraps

from django.db.models import Q


def smart_q(q_or_dict):
    if q_or_dict is None or q_or_dict is True:
        return q_or_dict
    if isinstance(q_or_dict, Q):
        return q_or_dict
    else:
        return Q(**q_or_dict)


def memoized_method(func):

    @wraps(func)
    def wrapper(self):
        if not hasattr(self, '__memoized__'):
            self.__memoized__ = {}

        key = func.__name__

        if key not in self.__memoized__:
            self.__memoized__[key] = func(self)

        return self.__memoized__[key]

    return wrapper
