from rest_framework import serializers

from .base import DynamicFieldsSerializer
from .person import PersonSerializer


class EventSerializer(DynamicFieldsSerializer):
    comment = serializers.CharField(required=False)
    is_hidden = serializers.BooleanField(required=False)
    is_active = serializers.BooleanField(required=False)
    level = serializers.IntegerField(required=False)
    revision = serializers.IntegerField(required=False)
    slot = serializers.IntegerField(required=False)
    initiator = PersonSerializer(required=False)
    happened_at = serializers.DateTimeField(required=False)
