from rest_framework import serializers


class ExceptionSerializer(serializers.Serializer):
    code = serializers.CharField()
    text = serializers.CharField()
    data = serializers.CharField()
    scope = serializers.CharField()


class ExceptionBlockSerializer(serializers.Serializer):
    errors = serializers.SerializerMethodField('format_errors')

    def format_errors(self, obj):
        if hasattr(obj, '__iter__'):
            errors = obj
        else:
            errors = [obj]

        return ExceptionSerializer(errors, many=True).data
