from django.core.urlresolvers import reverse

from rest_framework import serializers

from .base import AchieveryBaseSerializer


class IconSerializer(AchieveryBaseSerializer):
    id = serializers.IntegerField()
    level = serializers.IntegerField()
    is_big = serializers.BooleanField()
    url = serializers.SerializerMethodField('get_icon_url')
    data = serializers.CharField()

    @staticmethod
    def get_icon_url(obj):
        return reverse(
            'achievery:icon_raw',
            kwargs={
                'pk': obj.id,
                'size': 'big' if obj.is_big else 'small'
            }
        )
