from django import template


register = template.Library()


@register.inclusion_tag('achievery/tags/given_link.html', takes_context=True)
def given_link(context):
    return {
        'url': context['given_url'],
        'title': context['title'],
    }


@register.inclusion_tag('achievery/tags/initiator_link.html', takes_context=True)
def initiator_link(context):
    return {
        'url': context['initiator_url'],
        'name': context['initiator_name_ablative'],
    }


@register.filter
def first_letter(value):
    return value and value[0]


@register.filter
def last_letters(value):
    return value and value[1:]
