from django.conf.urls import url

from staff.achievery import views

urlpatterns = [
    url(
        r'^achievements/?$',
        views.AchievementListView.as_view(),
        name='achievements_list',
    ),

    url(
        r'^achievements/(?P<pk>\d+)/?$',
        views.AchievementDetailsView.as_view(),
        name='achievement_details',
    ),

    url(
        r'^given/?$',
        views.GivenListView.as_view(),
        name='given_list',
    ),

    url(
        r'^given/(?P<pk>\d+)/?$',
        views.GivenDetailsView.as_view(),
        name='given_details',
    ),

    url(
        r'^icons/(?P<yandex_login>[\w\-\.]+)/(?P<achievement_id>\d+)/(?P<size>big|small)/?$',
        views.IconByLoginRawView.as_view(),
        name='icon_by_login',
    ),

    url(
        r'^icons/(?P<pk>\d+)/(?P<size>big|small)/?$',
        views.IconRawView.as_view(),
        name='icon_raw',
    ),

    url(
        r'^create_achievement/?$',
        views.create_achievement_view,
        name='create_achievement',
    ),

    url(
        r'^create_achievement_validator/?$',
        views.validate_create_achievement,
        name='validate_create_achievement',
    ),
]
