from django.contrib import admin
from django.db import models
from django.contrib.auth.models import Group as DjangoGroup

from staff.lib.models.base import IntranetModel

from staff.person.models import Staff
from staff.groups.models import Group


class ProxyStaff(Staff):

    class Meta(IntranetModel.Meta):
        proxy = True
        permissions = (
            ("can_add_wiki_group", 'Can add wiki group'),
            ("can_edit_wiki_group", 'Can edit wiki group'),
            ("can_delete_wiki_group", 'Can delete wiki group'),
            ("can_view_vacation", 'Can view vacation'),
            ("can_view_paid_day_off", 'Can view paid day off'),
            ("can_view_meals_sum", 'Can view meals sum'),
            ("can_edit_work_phone", 'Can edit work phone'),
            ("can_view_contacts", 'Can view contacts'),
            ("can_view_emergency_phone", 'Can view emergency phone'),
            ("can_view_digital_sign", 'Can view digital sign phone'),
            ("can_edit_anketa", 'Can edit anketa'),
            ("can_set_big_boss", 'Can set big boss'),
            ("can_edit_department", 'Can edit department'),
            ("can_watch_department_proposals", 'Can watch department proposals list'),
            ("can_manage_department_proposals", 'Can manage department proposals'),
            ("can_execute_department_proposals", 'Can execute department proposals'),
            ("can_edit_official", 'Can edit official'),
            ("can_edit_head", 'Can edit head'),
            ("can_edit_location", 'Can edit location'),
            ("can_edit_keys", 'Can edit keys'),
            ("can_edit_join_at", 'Can edit join at date'),
            ("can_withdraw_keys", 'Can withdraw public keys'),
            ("can_see_keys_audit", 'Can see keys audit'),
            ("can_upload_photo", 'Can upload photo'),
            ("can_delete_all_photos", 'Can delete all photos'),
            ("kill_and_rob", 'Open department admin page'),
            ("can_view_upravlyator_link", "Can view upravlyator link"),
            ("can_view_cabinet_link", "Can view cabinet link"),
            ("can_view_password_block", 'Can view password block'),
            ("can_edit_celery_task", 'Can edit Celery tasks'),
            ("can_view_trip", 'Can view trip'),
            ("can_edit_trip", 'Can edit trip'),
            ("can_send_spam", 'Can send spam'),
            ("can_mass_give_achievements", 'Can mass give achievements'),
            ("can_view_permissions", 'Can view permissions'),
            ("can_view_structure_report", 'Can generate structure report'),
            ("can_view_staff_report", 'Can generate staff report'),
            ("can_view_persons_report", 'Can generate persons report'),
            ("can_view_lenta_report", 'Can generate lenta report'),
            ("can_view_headcount_report", 'Can generate headcount report'),
            ("can_view_dismissal_report", 'Can generate dismissal report'),
            ("can_view_oebs_unlinked_departments_report",
             'Can generate oebs unlinked departments report'),
            ("can_view_staff_ethic_report", 'Can view report for ethic courses'),
            ("can_view_oebs_unlinked_employees_report",
             'Can generate oebs unlinked employees report'),
            ("can_view_oebs_filred_employees_report",
             'Can generate oebs fired employees report'),
            ("can_view_oebs_chiefs_report", 'Can generate oebs chiefs report'),
            ("can_view_oebs_department_parents_report",
             'Can generate oebs department parents report'),
            ("can_view_trip_history", 'Can view trip history of any person'),
            ("can_view_anketa_wish_form_button",
             'Can view anketa Wish Form button'),
            ('can_manage_external_logins', 'Can manage external logins'),
            ('can_manage_ssh_key_for_externals',
             'Can manage ssh keys for external subordinates'),
            ('can_manage_gaps', 'Can manage gaps'),
            ('can_view_gaps_with_countries', 'Can view gaps with countries'),
            ('can_upload_any_ssh_key', 'Can upload any SSH key'),
            ('can_view_security_devices', 'Can view security devices on map'),
            ('can_add_security_devices', 'Can add security devices on map'),
            ('can_view_dismissed_official_base', 'Can view join_at and other on dismissed profile'),
            ('can_view_quit_at', 'Can view quit_at on profile'),
            ('can_view_gap_as_external', 'Can view gap (for external users only)'),
            ('can_view_contacts_as_external', 'Can view contacts (for external users only)'),
            ('can_use_handle_loan_available', 'Can use handle for loan availability'),
            ('robot_review_permission', 'Permission for robot-review'),
            ('can_change_staff', 'Can use handle change_staff'),
            ('robot_can_update_services', 'Robot ABC can update service'),
        )


class GroupDjangoGroup(models.Model):
    group = models.ForeignKey(Group)
    django_group = models.ForeignKey(DjangoGroup)

    def __str__(self):
        return '%s → %s' % (self.group.name, self.django_group.name)


class CenterGroupsAdmin(admin.ModelAdmin):
    id = models.IntegerField(primary_key=True)
    code = models.CharField(max_length=127)
    description = models.TextField()


class StaffUserException(Exception):
    pass


class OfficeSetting(models.Model):
    """
    Настройки для офисов
    """
    office = models.OneToOneField('django_intranet_stuff.Office', related_name='settings', verbose_name='Офис')
    needs_food_money_info = models.BooleanField(default=False, verbose_name='Деньги на еду')
    needs_hardware_info = models.BooleanField(default=True, verbose_name='Оборудование')
    needs_software_info = models.BooleanField(default=True, verbose_name='Программное обеспечение')
    needs_vacation_info = models.BooleanField(default=False, verbose_name='Отпуск')

    helpdesk_service = models.BooleanField(default=False, verbose_name='Хелпдеск')
    cadre_service = models.BooleanField(default=False, verbose_name='Отдел кадров')
    adaptation_service = models.BooleanField(default=False, verbose_name='Служба адаптации')

    class Meta:
        ordering = ('office__name',)
        # verbose_name = 'Настройка офиса'
        # verbose_name_plural = 'Настройки офисов'


class ExecutiveHead(models.Model):
    chief = models.ForeignKey('django_intranet_stuff.Staff')
    department = models.ForeignKey('django_intranet_stuff.Department')
    country = models.ForeignKey('django_intranet_stuff.Country')

    def __str__(self):
        if self.chief and self.department and self.country:
            return ('{s.chief.login} administrative head '
                    'of the department {s.department.url} '
                    'in {s.country.name}.').format(s=self)
