from django.conf import settings


def get_current_lang_ui(request):
    """
    Получаем теущий язык интерфейса выставленный у пользователя в куке
    или в параметрах в профайле

    @param request: dict Объект с параметрами запроса
    @return: str
    """

    profile = request.user.get_profile()
    lang_ui = settings.DEFAULT_LANG_UI
    if settings.INTRANET_LANGUAGE_COOKIE_NAME in request.COOKIES:
        lang_ui = request.COOKIES[settings.INTRANET_LANGUAGE_COOKIE_NAME]
    elif request.user.is_authenticated() and profile.lang_ui:
        lang_ui = profile.lang_ui

    if lang_ui in settings.INTRANET_LANGS_UI:
        return lang_ui
    else:
        return settings.DEFAULT_LANG_UI
