import sys
from optparse import make_option

from django.conf import settings
from django.core.management.base import BaseCommand

from staff.emission.django.emission_master.utils import load_model
from staff.emission.django.emission_master.controller import controller


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('--dry-run',
                    action='store_true',
                    default=False,
                    help='Don\'t do anything'),
    )

    def handle(self, *args, **options):
        verbosity = int(options['verbosity'])
        dry_run = options['dry_run']

        if not args:
            replicated_models = settings.EMISSION_MASTER_REPLICATED_MODELS
        else:
            raise NotImplementedError

        i = 0

        for m in replicated_models:
            cls = load_model(m)
            for obj in cls.objects.all():
                if not dry_run:
                    controller.append(obj)
                if verbosity > 1:
                    print('Put {0}'.format(obj))
                elif verbosity > 0 and i % 100 == int(i / 100):
                    sys.stdout.write('.')
                    sys.stdout.flush()

                i += 1

        if verbosity > 0:
            print('\nProcessed {0} objects'.format(i))
