from staff.departments.models import ProposalMetadata


def get_last_applied_proposal_info():
    last_applied_proposal_id, last_applied_at = (
        ProposalMetadata.objects
        .order_by('applied_at')
        .values_list('proposal_id', 'applied_at').last()
    )
    return {
        'last_applied_id': last_applied_proposal_id,
        'last_applied_date': last_applied_at,
    }
