import yenv

from django.conf.urls import url, include

from staff.api import views, testing_views

urlpatterns = [
    url(r'^get_vcard/(?P<login>[\w\-\_\.\,]+).vcf$', views.get_vcard, name='api-get_vcard'),
    url(r'^get_qr/(?P<login>[\w\-\_\.]+)/?$', views.get_qr, name='api-get_qr'),
    url(r'^get_whistlah/(?P<yandex_login>[\w\-\_\.]+)/?$', views.get_whistlah, name='api-get_whistlah'),
    url(
        r'^get_jabber_status/(?P<login_or_mail>[\w\-\_\.\@]+)/?$',
        views.get_jabber_status,
        name='api-get_jabber_status',
    ),
    url(r'^call/(?P<phone>.+)/?$', views.call, name='api-call'),
    url(r'^call_main_to_main/?$', views.call_main_to_main, name='api-call_main_to_main'),

    url(r'^call/(?P<phone>.+)/?$', views.call, name='api-call'),

    url(r'^set_staff_timezone/(?P<login>[\w\-\_\.\@]+)/?$', views.change_staff, name='api-change_staff'),
    url(r'^change_staff/(?P<login>[\w\-\_\.\@]+)/?$', views.change_staff, name='api-change_staff'),

    url(r'^users_byod_access.json$', views.users_byod_access, name='api-users_byod_access'),

    url(r'push/plan/service/(\d+)/?$', views.update_plan_service, name='api-push_plan_service'),

    url(r'^staff_with_chiefs/?$', views.staff_with_chiefs, name='staff-with-chiefs'),

    url(r'^emails/', include('staff.emails.urls')),

    url(r'^emission/', include('staff.emission.django.emission_master.urls')),

    url(r'achievery/', include('staff.achievery.urls', namespace='achievery')),

    url(r'user_settings/', include('staff.user_settings.urls', namespace='user_settings')),

    url(r'^idm/', include('django_idm_api.urls', namespace='client-api')),

    url(r'kudos/', include('staff.kudos.urls', namespace='kudos')),
]

if yenv.type in ('testing', 'development'):
    urlpatterns += [
        url(
            r'^(?P<url>\S+)/set_chief/?$',
            testing_views.set_chief,
            name='departments_set-chief',
        ),

        url(
            r'^(?P<url>\S+)/set_deputy/?$',
            testing_views.set_deputy,
            name='departments_set-deputy',
        ),

        url(
            r'create_user_in_testing/?$',
            testing_views.create_user_in_testing,
            name='create_user_in_testing',
        )
    ]
