from cgi import escape
from django.http import HttpResponse, Http404
from django.db.models import Q
from json import dumps
from staff.django_api_auth.decorators import check_referer
from staff.apicenter.utils import get_fields
from staff.maillists.models import List
from staff.maillists.api_v1 import _default_list_fields


class MaillistsAutocomplete(object):

    def get_maillists(self, request):
        q = request.GET.get('q', None)
        if not q:
            raise Http404
        try:
            limit = int(request.GET['limit'])
        except (TypeError, KeyError):
            limit = 10
        fields = get_fields(request, _default_list_fields)
        is_imap = request.GET.get('imap', False)

        lists = (
            List.objects
            .values(*fields)
            .filter(Q(name__startswith=q) | Q(email__startswith=q))
        )
        if not is_imap or is_imap.lower() in ('no', 'false', 'none', '0'):
            lists = lists.exclude(email='').exclude(email=None)
        res = list(lists[:limit])
        for l in res:
            if l['info']:
                l['info'] = escape(l['info'])
        return res

    @check_referer
    def __call__(self, request):
        res = dumps(self.get_maillists(request))
        if request.GET.get('callback', None):
            res = 'var data = %s; %s(data);' % (res, request.GET.get('callback'))

        return HttpResponse(res, content_type='text/javascript')
