from django.conf.urls import url

from staff.apicenter.autocomplete.departments import DepartmentsAutocomplete
from staff.apicenter.autocomplete.groups import GroupsAutocomplete
from staff.apicenter.autocomplete.users import AutocompleteUsersView
from staff.apicenter.autocomplete.maillists import MaillistsAutocomplete
from staff.apicenter.autocomplete.users_and_maillists import UsersAndMallistsAutocompleteView
from staff.apicenter.autocomplete import resources  # noqa required to import MulticompleteView correctly

from staff.multic.views import MulticompleteView

urlpatterns = [
    url(r'^groups/?$', GroupsAutocomplete(), name='groups_autocomplete'),
    url(r'^departments/?$', DepartmentsAutocomplete(), name='departments_autocomplete'),
    url(r'^users/?$', AutocompleteUsersView(), name='autocomplete_users'),
    url(r'^maillists/?$', MaillistsAutocomplete(), name='maillists_autocomplete'),

    # TODO: заменить мультикомплитом и выпилить
    url(r'^users_and_maillists/?$', UsersAndMallistsAutocompleteView(), name='autocomplete_users_and_maillists'),

    url(r'^multi/?$', MulticompleteView.as_view(), name='multi')
]
