from django.http import HttpResponse

from staff.lib.decorators import available_by_center_token
from staff.lib.json import dumps

from staff.apicenter.autocomplete.maillists import MaillistsAutocomplete
from staff.apicenter.autocomplete.users import AutocompleteUsersView


@available_by_center_token
class UsersAndMallistsAutocompleteView(AutocompleteUsersView, MaillistsAutocomplete):

    def __call__(self, request):
        res = self.get_users(request) + self.get_maillists(request)
        res = dumps(res)
        callback = request.GET.get('callback', request.POST.get('callback', None))
        if callback:
            res = '%s(%s);' % (callback, res)
        return HttpResponse(res, content_type='text/javascript')
