from django.conf.urls import url, include

from staff.django_rpc.views import handle_rpc

from staff.apicenter import api_v1

from staff.apicenter.v1.gap import AbsenceByUserView
from staff.apicenter.v1.services import services_list_v1
from staff.apicenter.v1.users import UsersView
from staff.apicenter.v1.whistlah import UserWhereView

urlpatterns = [

    url(r'^api/xmlrpc/?$', handle_rpc, {'type': 'xml'}),

    # API v1
    # users
    url(r'^api/v1/user\.(json|jsonp)$', api_v1.current_user, name='current_user'),
    url(r'^api/v1/user/([A-Za-z0-9\.\-_@|]+)\.(json|jsonp)$', api_v1.user, name='user'),
    url(
        r'^api/v1/user/([A-Za-z0-9\.\-_]+)/groups\.(json|jsonp)$',
        api_v1.user_groups,
        name='user_groups',
    ),
    url(r'^api/v1/users\.(json|jsonp|xml)$',  UsersView.as_view(), name='all_users'),
    url(r'^api/v1/user/([A-Za-z0-9\.\-_|]+)/where\.(json|jsonp)$', UserWhereView.as_view(), name='api_v1_user_where'),

    # groups
    url(r'^api/v1/groups\.(json|jsonp)$', api_v1.groups, name='groups'),
    url(r'^api/v1/groups/([A-Za-z0-9\.\-_]+)\.(json|jsonp)$', api_v1.group, name='group'),
    url(
        r'^api/v1/groups/([A-Za-z0-9\.\-_]+)/all_members\.(json|jsonp)$',
        api_v1.group_all_members,
        name='group_all_members',
    ),

    # departments
    url(r'^api/v1/departments(\.json|\.jsonp)$', api_v1.departments, name='departments'),

    # gap
    url(
        r'^api/v1/absence_by_user/([A-Za-z0-9\.\-_|]+)\.(json|jsonp|xml)$',
        AbsenceByUserView.as_view(),
        name='absence_by_user',
    ),

    # apiv2
    url(r'^api/v2/', include('staff.apicenter.v2.urls', namespace='api_v2')),

    # autocompletes
    url(r'^api/autocomplete/', include('staff.apicenter.autocomplete.urls', namespace='autocomplete')),

    url(r'^services/v1/?$', services_list_v1, name='services_list_v1'),
]
