from django.views.decorators.http import require_GET
from django.http import HttpResponse, HttpResponseBadRequest

from staff.person.models import Staff
from staff.lib.json import dumps

from staff.django_api_auth.decorators import check_referer


NAMES = {
    'ru': {
        'wiki': 'Вики-страница',
        'jira': 'Задачи',
        'invite': 'Встречи',
        'ml': 'Подписки',
        'jabber': 'Джаббер-переписка',
        'projects': 'Проекты',
        'at': 'Блог',
        'jing': 'Скриншоты',
        'conductor': 'Кондуктор',
        'lunapark': 'Лунапарк',
    },
    'en': {
        'wiki': 'Wiki page',
        'jira': 'Task',
        'invite': 'Meetings',
        'ml': 'Subscriptions',
        'jabber': 'Jabber history',
        'projects': 'Projects',
        'at': 'Blog',
        'jing': 'Screenshots',
        'conductor': 'Conductor',
        'lunapark': 'Lunapark',
    }
}

URLS = {
    'wiki': '//wiki.yandex-team.ru/~%s',
    'jira': '//jira.yandex-team.ru/secure/ViewProfile.jspa?name=%s',
    'invite': '//invite.yandex-team.ru/my/',
    'ml': '//ml.yandex-team.ru/staff/%s/',
    'jabber': '//mail.yandex-team.ru/neo/webchat_history_all',
    'projects': '//planner.yandex-team.ru/cabinet/%s',
    'conductor': '//c.yandex-team.ru/tickets/recent',
    'at': '//%s.at.yandex-team.ru/',
    'jing': '//jing.yandex-team.ru/files/%s',
    'lunapark': '//lunapark.yandex-team.ru/person/%s',
}


def _prepare(code, staff, lang):
    if URLS[code].find('%s') != -1:
        url = URLS[code] % staff.login_ld
    else:
        url = URLS[code]

    if code in NAMES[lang]:
        name = NAMES[lang][code]
    else:
        name = code.capitalize()

    return {
        'id': code,
        'title': name,
        'url': url
    }


def _get_data(request):
    r = {
        'login': request.user.username,
        'services': [],
        'intranet_alerts': []
    }
    try:
        staff = request.user.get_profile()
    except Staff.DoesNotExist:
        return dumps(r)

    lang = request.LANGUAGE_CODE
    if hasattr(staff, 'get_full_name'):
        r['login'] = staff.get_full_name()

    if isinstance(staff, Staff):
        r['services'].append(_prepare('wiki', staff, lang))
        if staff.work_email:
            r['services'].append(_prepare('jira', staff, lang))
            r['services'].append(_prepare('invite', staff, lang))
            r['services'].append(_prepare('ml', staff, lang))
            r['services'].append(_prepare('jabber', staff, lang))
        r['services'].append(_prepare('projects', staff, lang))
        r['services'].append(_prepare('at', staff, lang))
        r['services'].append(_prepare('jing', staff, lang))
        r['services'].append(_prepare('conductor', staff, lang))
        r['services'].append(_prepare('lunapark', staff, lang))

    return r


def _get_data_v1(request):
    r = _get_data(request)
    r['full_name'] = r['login']
    r['login'] = request.user.username

    return r


def _services_list(request, _get_data_f):
    callback = request.GET.get('callback', request.POST.get('callback', None))

    if not callback:
        return HttpResponseBadRequest()

    return HttpResponse(
        '%s(%s)' % (callback, dumps(_get_data_f(request))),
        content_type='text/javascript'
    )


@require_GET
@check_referer
def services_list_v1(request):
    return _services_list(request, _get_data_v1)
