from staff.person.models import Staff
from staff.map.models import Office

from staff.whistlah.models import StaffLastOffice

from staff.lib.decorators import available_by_center_token

from staff.apicenter.v2.base_views import Apiv2ListView

LAST_OFFICE_DEFAULT_FIELDS = ('id', 'staff_id', 'office_id', 'updated_at')
LAST_OFFICE_RELATED_FIELDS = {'staff': Staff,
                              'office': Office}


@available_by_center_token
class LastOfficeListView(Apiv2ListView):
    model = StaffLastOffice
    queryset = model.objects.all()
    entities = ('last_offices', 'last_office')

    default_fields = LAST_OFFICE_DEFAULT_FIELDS
    related_fields = LAST_OFFICE_RELATED_FIELDS
