import json

from django.core import serializers

from staff.audit.models import Log
from staff.lib.utils.ordered_choices import OrderedChoices


AUDIT_ACTIONS = OrderedChoices(
    ('ATTACH_PHONE_TO_DS', 'attach_phone_to_ds'),
    ('VERIFY_PHONE_CODE_DS', 'verify_phone_code_ds'),
    ('CONNECT_PHONE_IN_OEBS_TO_DS', 'connect_phone_in_oebs_to_ds'),
)


RENDER_AS_IS = {
    AUDIT_ACTIONS.ATTACH_PHONE_TO_DS,
    AUDIT_ACTIONS.VERIFY_PHONE_CODE_DS,
    AUDIT_ACTIONS.CONNECT_PHONE_IN_OEBS_TO_DS,
}


# TODO: хорошо бы более универсальный сериализатор, потому что этим только
# модели можно сериализовать.
def build_log(objects, who, action, primary_key):
    log = Log(who=who, action=action, primary_key=primary_key)
    if isinstance(objects, str):
        log.data = objects
    elif isinstance(objects, dict):
        log.data = json.dumps(objects)
    else:
        log.data = serializers.serialize('json', objects)
    return log


def create_log(objects, who, action, primary_key):
    log = build_log(objects, who, action, primary_key)
    log.save()
    return log
