from django import forms

from staff.lib.validators import validate_login

DATETIME_INPUT_FORMATS = (
    '%d.%m.%Y %H:%M:%S',     # '25.10.2006 14:30:59'
    '%d.%m.%Y %H:%M',        # '25.10.2006 14:30'
    '%d.%m.%Y',              # '25.10.2006'
)


class AuditFilter(forms.Form):
    who = forms.CharField(
        label='Editor1',
        help_text='login',
        validators=[validate_login],
        required=False,
    )

    action = forms.CharField(
        label='Action contains',
        help_text='substring',
        required=False,
    )

    primary_key = forms.IntegerField(
        label='id',
        help_text='primary_key',
        required=False,
    )

    modified_from = forms.DateTimeField(
        label='Modified from',
        input_formats=DATETIME_INPUT_FORMATS,
        help_text='date and/or time',
        required=False,
    )

    modified_to = forms.DateTimeField(
        label='Modified to',
        input_formats=DATETIME_INPUT_FORMATS,
        help_text='date and/or time',
        required=False,
    )
