from django.db import models


class Log(models.Model):
    class Meta:
        permissions = (
            ("can_see_audit", 'Can see audit'),
        )

    # FIXME: может позволить null=True, чтобы логгировать из менеджмент-команд
    who = models.ForeignKey('users.User')
    action = models.CharField(max_length=100)
    data = models.TextField()
    modified_at = models.DateTimeField(auto_now=True)
    primary_key = models.IntegerField(null=True)
