from staff.lib.utils.enum_choices import EnumChoices
from staff.lib.utils.ordered_choices import OrderedChoices


class InitStatus(EnumChoices):
    CREATED = 'created'
    EXISTS = 'exists'
    HAS_CONFLICT_CHANGE = 'has conlfict change'


class PositionType(EnumChoices):
    EMPTY = 'empty'
    MATERNITY = 'maternity'
    NEGATIVE_RESERVE = 'negative_reserve'
    OFFER = 'offer'
    PLAN_HIRING = 'plan_hiring'
    PLAN_REPLACEMENT = 'plan_replacement'
    RESERVE = 'reserve'
    VACANCY = 'vacancy'


WORKFLOW_STATUS = OrderedChoices(
    ('PENDING', 'pending', 'В ожидании'),
    ('CANCELLED', 'cancelled', 'Отменено'),
    ('CONFIRMED', 'confirmed', 'Согласовано'),
    ('QUEUED', 'queued', 'В очереди на OEBS'),
    ('PUSHED', 'pushed', 'Отправляется'),
    ('SENDING_NOTIFICATION', 'notifying', 'Рассылка нотификаций'),
    ('FINISHED', 'finished', 'Отправлено'),
)


PUSH_STATUS = OrderedChoices(
    ('PUSHED', 'pushed', 'Применяется'),
    ('ERROR', 'error', 'Ошибка'),
    ('FINISHED', 'finished', 'Применено'),
)


class FemidaRequestType(EnumChoices):
    VACANCY = 'vacancy'
    OFFER = 'offer'
    INTERNAL_OFFER = 'internal_offer'
    OFFER_REJECTION = 'offer_rejection'
    VACANCY_CANCELLATION = 'vacancy_cancellation'


class FemidaProfessionalLevel(EnumChoices):
    intern = 1
    junior = 2
    middle = 3
    senior = 4
    lead = 5
    expert = 6
