from typing import Optional

from staff.budget_position.models import BudgetPosition, BudgetPositionComment
from staff.person.models import Staff


def attach_comment_to_budget_position_controller(
    person: Staff,
    budget_position: BudgetPosition,
    comment: Optional[str],
) -> None:
    if not comment:
        BudgetPositionComment.objects.filter(person=person, budget_position=budget_position).delete()
    else:
        budget_position_comment, _ = BudgetPositionComment.objects.get_or_create(
            person=person,
            budget_position=budget_position,
        )
        budget_position_comment.comment = comment
        budget_position_comment.save()
