from typing import Optional

from staff.departments.models import HRProduct

from staff.budget_position.models import BudgetPositionAssignment
from staff.budget_position.models import BudgetPosition


def check_if_hr_product_changed_controller(
    budget_position: BudgetPosition,
    hr_product: Optional[HRProduct],
) -> bool:
    assignment_qs = BudgetPositionAssignment.objects.active().filter(budget_position=budget_position)
    current_hr_products = list(
        HRProduct.objects
        .filter(value_stream_id__in=assignment_qs.values_list('value_stream_id', flat=True))
    )

    if len(current_hr_products) > 1:
        return True

    if len(current_hr_products) == 0:
        return hr_product is not None

    return current_hr_products[0] != hr_product
