from typing import Union, Optional

from decimal import Decimal

import datetime
from dateutil import parser

from staff.payment.enums import WAGE_SYSTEM


def wage_system_converter(wage_system: Optional[str]) -> Optional[str]:
    return (
        WAGE_SYSTEM.FIXED
        if wage_system == 'monthly'  # прилетает из фемиды, равен нашему fixed
        else wage_system or None
    )


def pay_system_converter(wage_system: Optional[str]) -> Optional[str]:
    if not wage_system:
        return None
    converted_wage_system = wage_system_converter(wage_system)
    return {
        WAGE_SYSTEM.PIECEWORK: 'XXYA_JOBPRICE',
        WAGE_SYSTEM.HOURLY: 'XXYA_FIXED_SALARY',
        WAGE_SYSTEM.FIXED: 'XXYA_FIXED_SALARY',
    }.get(converted_wage_system, converted_wage_system)


def date_converter(date_to_convert: Union[datetime.date, datetime.datetime, str, None]) -> Optional[datetime.date]:
    if not date_to_convert:
        return None
    if isinstance(date_to_convert, str):
        date_to_convert = parser.parse(date_to_convert)
    if isinstance(date_to_convert, datetime.datetime):
        date_to_convert = date_to_convert.date()
    return date_to_convert


def position_name_converter(position_name: Optional[str]) -> Optional[str]:
    if not position_name:
        return None
    return position_name[:60]


def salary_converter(salary: Union[Decimal, int, str, None]) -> Optional[Decimal]:
    if not salary and salary != 0:
        return None
    return Decimal(salary)


def rate_converter(rate: Union[Decimal, int, str, None]) -> Optional[Decimal]:
    if not rate and rate != 0:
        return None
    return Decimal(rate)
