from typing import Optional

import sform

from staff.budget_position.models import BudgetPosition


class BudgetPositionCommentForm(sform.SForm):
    budget_position = sform.SuggestField(
        queryset=BudgetPosition.objects.all(),
        state=sform.REQUIRED,
        label_fields={'caption': ('id',)},
        to_field_name='code',
    )
    comment = sform.CharField(max_length=255, state=sform.NORMAL)

    @staticmethod
    def clean_comment(value: Optional[str]):
        if not value:
            return value
        return value.strip()
