import sform

from staff.departments.models import HRProduct

from staff.budget_position.models import BudgetPosition


class CheckIfHrProductChangedForm(sform.SForm):
    budget_position = sform.SuggestField(
        queryset=BudgetPosition.objects.all(),
        state=sform.REQUIRED,
        label_fields={'caption': ('id',)},
        to_field_name='code',
    )
    hr_product_id = sform.SuggestField(
        queryset=HRProduct.objects.active(),
        to_field_name='id',
        label_fields=('product_name',),
    )
