import sform


from staff.map.models import Office
from staff.person.models import Organization


class PlacementForm(sform.SForm):
    office = sform.ModelChoiceField(
        queryset=Office.objects.filter(intranet_status=1).order_by('name'),
        label_extractor='name',
        state=sform.REQUIRED,
    )

    organization = sform.ModelChoiceField(
        queryset=Organization.objects.filter(intranet_status=1).order_by('name'),
        label_extractor='name',
        state=sform.REQUIRED,
    )

    @property
    def office_id(self):
        return self.cleaned_data['office'].id

    @property
    def organization_id(self):
        return self.cleaned_data['organization'].id
