# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
            options={
                'permissions': (('can_manage_market_budget_positions', 'Permission for managing budget positions in Market'),),
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='BudgetPosition',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('code', models.IntegerField(unique=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ChangeRegistry',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('currency', models.CharField(verbose_name='Валюта оклада', max_length=4, null=True)),
                ('dismissal_date', models.DateField(verbose_name='Дата увольнения', null=True)),
                ('effective_date', models.DateField(verbose_name='Дата действия', null=True)),
                ('headcount', models.IntegerField(verbose_name='Численность', null=True)),
                ('wage_system', models.CharField(verbose_name='Тип оклада', max_length=32, null=True)),
                ('position_name', models.CharField(verbose_name='Название БП', max_length=60, null=True)),
                ('position_type', models.CharField(verbose_name='Статус', max_length=64, null=True, choices=[('empty', 'empty'), ('maternity', 'maternity'), ('negative_reserve', 'negative_reserve'), ('offer', 'offer'), ('plan_hiring', 'plan_hiring'), ('plan_replacement', 'plan_replacement'), ('reserve', 'reserve'), ('vacancy', 'vacancy')])),
                ('rate', models.DecimalField(verbose_name='Ставка', null=True, max_digits=16, decimal_places=3)),
                ('salary', models.DecimalField(verbose_name='Оклад', null=True, max_digits=16, decimal_places=3)),
                ('ticket', models.CharField(verbose_name='Тикет', max_length=32, null=True)),
                ('optional_ticket', models.CharField(verbose_name='Еще один опциональный тикет', max_length=32, null=True)),
                ('remove_budget_position', models.NullBooleanField()),
                ('unit_manager', models.NullBooleanField()),
                ('employment_type', models.CharField(verbose_name='Тип найма', max_length=16, null=True)),
                ('person_id', models.IntegerField(verbose_name='ID физ. лица', null=True)),
                ('other_payments', models.CharField(verbose_name='Прочие платежи', max_length=255, null=True)),
                ('join_at', models.DateField(verbose_name='Дата приема', null=True)),
                ('probation_period_code', models.IntegerField(verbose_name='Испытательный срок (код)', null=True)),
                ('is_replacement', models.NullBooleanField(verbose_name='Является заменой')),
                ('instead_of_login', models.CharField(verbose_name='Логин заменяемого', max_length=50, null=True)),
                ('contract_term_date', models.DateField(verbose_name='Дата окончания контракта', null=True)),
                ('contract_period', models.IntegerField(verbose_name='Продолжительность контракта (месяцы)', null=True)),
                ('oebs_transaction_id', models.IntegerField(null=True)),
                ('correction_id', models.IntegerField(null=True)),
                ('push_status', models.CharField(max_length=32, null=True, choices=[('pushed', 'Применяется'), ('error', 'Ошибка'), ('finished', 'Применено')])),
                ('sent_to_oebs', models.DateTimeField(null=True)),
                ('assignment_id', models.IntegerField(blank=True, null=True)),
                ('pushed_to_femida', models.DateTimeField(null=True)),
            ],
            options={
                'permissions': (('can_export_changes', 'Can export changes'),),
            },
        ),
        migrations.CreateModel(
            name='FemidaPushOutbox',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
        ),
        migrations.CreateModel(
            name='OEBSGrade',
            fields=[
                ('grade_id', models.IntegerField(primary_key=True, serialize=False)),
                ('level', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ProfLevelMapping',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('intern', models.PositiveIntegerField(blank=True, null=True)),
                ('junior', models.PositiveIntegerField(blank=True, null=True)),
                ('middle', models.PositiveIntegerField(blank=True, null=True)),
                ('senior', models.PositiveIntegerField(blank=True, null=True)),
                ('lead', models.PositiveIntegerField(blank=True, null=True)),
                ('expert', models.PositiveIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Workflow',
            fields=[
                ('id', models.UUIDField(primary_key=True, default=uuid.uuid1, serialize=False)),
                ('code', models.CharField(max_length=32)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('confirmed_at', models.DateTimeField(null=True)),
                ('status', models.CharField(max_length=32, default='pending', choices=[('pending', 'В ожидании'), ('cancelled', 'Отменено'), ('confirmed', 'Согласовано'), ('queued', 'В очереди на OEBS'), ('pushed', 'Отправляется'), ('notifying', 'Рассылка нотификаций'), ('finished', 'Отправлено')])),
                ('permission_date', models.DateField(null=True)),
                ('manually_processed', models.NullBooleanField(default=None)),
            ],
        ),
    ]
