# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0004_remove_department_dynamic_url'),
        ('departments', '0005_department_not_nullable'),
        ('budget_position', '0007_remove_changeregistry_geography'),
    ]

    operations = [
        migrations.CreateModel(
            name='BudgetPositionAssignment',
            fields=[
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('version', models.IntegerField(default=1)),
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('oebs_id', models.CharField(max_length=64, null=True)),
                ('change_reason', models.CharField(max_length=64, null=True)),
                ('status', models.CharField(max_length=32, choices=[('occupied', 'occupied'), ('offer', 'offer'), ('vacancy_open', 'vacancy_open'), ('vacancy_plan', 'vacancy_plan'), ('reserve', 'reserve'), ('maternity', 'maternity')])),
                ('creates_new_position', models.BooleanField()),
                ('replacement_type', models.CharField(max_length=32, choices=[('has_replacement', 'has_replacement'), ('busy', 'busy'), ('has_replacement_and_busy', 'has_replacement_and_busy'), ('without_replacement', 'without_replacement')])),
                ('main_assignment', models.BooleanField(default=True)),
                ('bonus_id', models.IntegerField()),
                ('reward_id', models.IntegerField()),
                ('review_id', models.IntegerField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='budgetposition',
            name='headcount',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='budgetposition',
            name='type',
            field=models.CharField(max_length=32, null=True, choices=[('intern', 'intern'), ('maternity', 'maternity'), ('credit', 'credit')]),
        ),
        migrations.AlterField(
            model_name='budgetposition',
            name='code',
            field=models.IntegerField(unique=True),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='budget_position',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='budget_position.BudgetPosition'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='change_registry',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.PROTECT, to='budget_position.ChangeRegistry'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='department',
            field=models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.PROTECT, to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='geography',
            field=models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.PROTECT, to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='person',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.PROTECT, to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='previous_assignment',
            field=models.ForeignKey(null=True, related_name='next_assignment', to='budget_position.BudgetPositionAssignment'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='vacancy',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.PROTECT, to='departments.Vacancy'),
        ),
        migrations.AddField(
            model_name='budgetpositionassignment',
            name='value_stream',
            field=models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.PROTECT, to='django_intranet_stuff.Department'),
        ),
    ]
